'=============================================================
'                      Terms of License
' -----------------------------------------------------------
' Terminabrechnung  2024 by Jens-Christian Wawrczeck
' is licensed under *CC BY-SA 4.0*
' (Creative Commons Attribution-ShareAlike 4.0 International)
' -----------------------------------------------------------
' To view a copy of this license, visit
' https://creativecommons.org/licenses/by-sa/4.0/
'=============================================================

Option Compare Binary       'Binary wichtig fr .LastModified !
Option Explicit

Private Sub Fenster_schliessen_Click()
On Error GoTo Err_Fenster_schliessen_Click

    Dim stDocName As String
    Dim stLinkCriteria As String
    
    
    stDocName = "Einstellungen_2"
    DoCmd.OpenForm stDocName, , , stLinkCriteria
    
    'Aktuelle Einstellungen-Maske schlieen, um evtl. genderte Daten zu speichern, damit eine
    'Kollision mit nderungen auf der anderen Einst.-Maske vermieden wird (Fehlermeldung).
    DoCmd.Close acForm, "Kalender_zusammenfuehren", acSaveYes
    

Exit_Fenster_schliessen_Click:
    Exit Sub

Err_Fenster_schliessen_Click:
    MsgBox err.Description
    Resume Exit_Fenster_schliessen_Click
    
End Sub

Private Sub Form_Load()
    On Error Resume Next
    DoCmd.Close acForm, "Kategorien", acSaveYes
    DoCmd.Close acForm, "Kunden", acSaveYes
    DoCmd.Close acForm, "Rechnungen_Uebersicht", acSaveYes
    DoCmd.Close acForm, "Einstellungen_2", acSaveYes
    
    DoCmd.Close acForm, "Bitte_warten", acSaveYes
End Sub

Private Sub Form_Open(Cancel As Integer)
    'alle Eingabefelder sperren
    Me.START_Button.Enabled = False
End Sub

Private Sub START_Button_Click()
'On Error GoTo Err_START_Button_Click

    Dim dbs As Database, rst As Recordset
    Dim rstKategorie As Recordset
    Dim rstTerminKalenderRaster As Recordset
    Dim strFilter As String
    Dim strFilter2 As String
    Dim strAbfrage As String
    Dim stDocName As String
    Dim fs As Object
    Dim tf As Object
    Dim Pfad As String, AktVerzeichnis As String
    Dim TermineExport As Integer
    Dim TermineGeloescht As Integer
    Dim TerminICS As String
    
    If MsgBox("Mchten Sie die nderungen wirklich vornehmen?", vbYesNo + vbDefaultButton2 + vbExclamation, "Achtung") <> vbYes Then
        Exit Sub
    End If
    
    'Textdatei fr ICS-Datei der zu bertragenden Termine anlegen
    AktVerzeichnis = Left(CurrentDb.Name, Len(CurrentDb.Name) - Len(Dir(CurrentDb.Name)))
    Pfad = AktVerzeichnis & TextEingabe & ".ics"        'TextEingabe wird bei ZU-Kalender-Auswahl gesetzt: Name des Ziel-Kalenders
    Set fs = CreateObject("Scripting.FileSystemObject")
    Set tf = fs.OpenTextFile(Pfad, 2, True, 0)                ' 2 = For Writing; True = Create; x = Tristatstatus (Zeichensatz) fr korrektes "" etc.
                                                                                               ' 0 = ASCII
                                                                                               '-1 = A0r0s0c0h0 mit BOM
                                                                                               '-2 = (ASCII)
    'MUSTER:  TerminICS = ANSIzuUTF8String("Mbelhbner", True)          ' True = OHNE BOM, sonst ohne 2. Parameter
    '         tf.WriteLine (TerminICS)
    
    'ICS-Kopfdaten in die Datei schreiben
    tf.WriteLine ("BEGIN:VCALENDAR")
    tf.WriteLine ("PRODID:-//Terminabrechnung by Jens-Christian Wawrczeck//DE")
    tf.WriteLine ("VERSION:" & Left(VersionProgramm, 10))
    tf.WriteBlankLines (1)
    tf.WriteLine ("BEGIN:VTIMEZONE")                       ' Zeitzonendaten fr Europische Sommerzeit,
    tf.WriteLine ("TZID:Europe/Berlin")                    ' falls bentigt
    tf.WriteLine ("BEGIN:DAYLIGHT")
    tf.WriteLine ("TZOFFSETFROM:+0100")
    tf.WriteLine ("TZOFFSETTO:+0200")
    tf.WriteLine ("TZNAME:CEST")
    tf.WriteLine ("DTSTART:19700329T020000")
    tf.WriteLine ("RRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=3")
    tf.WriteLine ("END:DAYLIGHT")
    tf.WriteLine ("BEGIN:STANDARD")
    tf.WriteLine ("TZOFFSETFROM:+0200")
    tf.WriteLine ("TZOFFSETTO:+0100")
    tf.WriteLine ("TZNAME:CET")
    tf.WriteLine ("DTSTART:19701025T030000")
    tf.WriteLine ("RRULE:FREQ=YEARLY;BYDAY=-1SU;BYMONTH=10")
    tf.WriteLine ("END:STANDARD")
    tf.WriteLine ("END:VTIMEZONE")
    tf.WriteBlankLines (1)

    'Datenbankumgebung festlegen
    Set dbs = CurrentDb

    'zur Suche der Termine im ZIEL-Kalender
    Set rst = dbs.OpenRecordset("SELECT * FROM Termine ORDER BY Start")
    rst.MoveLast        'auffllen

    Set rstKategorie = dbs.OpenRecordset("SELECT * FROM Kategorien ORDER BY lfd_Nr")
    rstKategorie.MoveLast       'auffllen



    TermineExport = 0
    TermineGeloescht = 0

    'Termine mit VON-Kalender
    Set rstTermine = dbs.OpenRecordset("SELECT * FROM Termine WHERE [lfd_Nr_Kalender] = " & Me.Von_Kalender.Value & " ORDER BY Start")
    If rstTermine.RecordCount > 0 Then
        rstTermine.MoveLast         'auffllen
        rstTermine.MoveFirst

        'Fortschrittsdialog auf den Schirm bringen
        stDocName = "Terminlauf"
        DoCmd.OpenForm stDocName
        'Anzeigen fllen
        Forms!Terminlauf.Re_Termin_gesamt.Caption = rstTermine.RecordCount
        Forms!Terminlauf.Caption = "Termine prfen..."
        ShowProgress Forms!Terminlauf.Verlauf_Balken, 1, 100
        NummeroGesamt = rstTermine.RecordCount
        NummeroTermin = 0

        'Termine durchgehen
        Do While rstTermine.EOF = False

            'Anzeige aktualisieren
            NummeroTermin = NummeroTermin + 1
            ShowProgress Forms!Terminlauf.Verlauf_Balken, NummeroTermin - 1, NummeroGesamt
            Forms!Terminlauf.Re_Termin_aktuell.Caption = NummeroTermin
            Forms!Terminlauf.Re_Termindatum.Caption = rstTermine!Start
            Forms!Terminlauf.Repaint
            DoEvents                    'Versuch, Systemhnger zu verhindern

            'Abfrage fr Zielkalender vorbereiten
            strAbfrage = "[lfd_Nr_Kalender]=" & Me.Zu_Kalender.Value & " AND [S_Jahr]=" & rstTermine!S_Jahr & " AND [S_Monat]=" & rstTermine!S_Monat & " AND [S_Tag]=" & rstTermine!S_Tag & " AND [S_Stunde]=" & rstTermine!S_Stunde & " AND [S_Minute]=" & rstTermine!S_Minute & _
                                                                       " AND [E_Jahr]=" & rstTermine!E_Jahr & " AND [E_Monat]=" & rstTermine!E_Monat & " AND [E_Tag]=" & rstTermine!E_Tag & " AND [E_Stunde]=" & rstTermine!E_Stunde & " AND [E_Minute]=" & rstTermine!E_Minute
            'Termin mit ZIEL-Kalender suchen
            rst.FindFirst (strAbfrage)
            If rst.NoMatch = False Then
                'wenn Termin anhand der Zeiten gefunden, dann noch ID oder Betreff vergleichen:
                'Betreff kann nicht im SQL-String verglichen werden, wegen mglicher ["] Anfhrungszeichen im Betreff!
                If (rstTermine!Termin_ID = rst!Termin_ID) Or (rstTermine!Betreff = rst!Betreff) Then
                    'Termine stimmen berein
                    'Termin wurde im Ziel-Kalender gefunden,
                    'ist also bereits vorhanden, kann gelscht werden

                    'zunchst Kalender-Raster lschen
                    Set rstTerminKalenderRaster = dbs.OpenRecordset("SELECT * FROM Termine_Kalender WHERE [lfd_Nr_Termin]=" & rstTermine!lfd_Nr)
                    If rstTerminKalenderRaster.RecordCount > 0 Then
                        rstTerminKalenderRaster.MoveLast    'auffllen
                        rstTerminKalenderRaster.MoveFirst
                        Do While Not rstTerminKalenderRaster.EOF
                            rstTerminKalenderRaster.Delete
                            rstTerminKalenderRaster.MoveNext
                        Loop
                    End If
                    rstTerminKalenderRaster.Close

                    rstTermine.Delete

                    TermineGeloescht = TermineGeloescht + 1

                Else
                    'Termin wurde im Ziel-Kalender NICHT gefunden

                    'Termindaten nach ICS exportieren
                    tf.WriteLine ("BEGIN:VEVENT")
                    TerminICS = "CREATED:" & Format(Now(), "yyyymmdd") & "T000000"
                    tf.WriteLine (TerminICS)
                    TerminICS = "LAST-MODIFIED:" & Format(Now(), "yyyymmdd") & "T000000"
                    tf.WriteLine (TerminICS)
                    TerminICS = "DTSTAMP:" & Format(Now(), "yyyymmdd") & "T000000"
                    tf.WriteLine (TerminICS)
                    'Kategorie ermitteln
                    If rstTermine!lfd_Nr_Kategorie <> SatzKategorieDummy Then
                        'nur wenn die eingetragene Kategorienummer nicht der DummyNr. entspricht
                        strFilter = "[lfd_Nr]=" & rstTermine!lfd_Nr_Kategorie
                        rstKategorie.FindFirst (strFilter)
                        If rstKategorie.NoMatch = False Then
                            'Doppelte Absicherung gegen die Dummy-Kategorie
                            If rstKategorie!Kategorie_ID <> KategorieDummy Then
                                TerminICS = "CATEGORIES:" & rstKategorie!Name1
                                tf.WriteLine (ANSIzuUTF8String(TerminICS, True))
                            End If
                        End If
                    End If
                    TerminICS = "SUMMARY:" & rstTermine!Betreff
                    tf.WriteLine (ANSIzuUTF8String(TerminICS, True))
                    'Termin Privat?
                    If rstTermine!Privat = True Then
                        tf.WriteLine ("CLASS:PRIVATE")
                    End If
                    TerminICS = "UID:" & rstTermine!Termin_ID
                    tf.WriteLine (TerminICS)
                    TerminICS = "DTSTART:" & Format(rstTermine!Start, "yyyymmdd") & "T" & Format(rstTermine!Start, "HHMM") & "00"
                    tf.WriteLine (TerminICS)
                    TerminICS = "DTEND:" & Format(rstTermine!Ende, "yyyymmdd") & "T" & Format(rstTermine!Ende, "HHMM") & "00"
                    tf.WriteLine (TerminICS)

                    tf.WriteLine ("END:VEVENT")
                    tf.WriteBlankLines (1)

                    'zunchst Kalender-Raster bearbeiten
                    Set rstTerminKalenderRaster = dbs.OpenRecordset("SELECT * FROM Termine_Kalender WHERE [lfd_Nr_Termin]=" & rstTermine!lfd_Nr)
                    If rstTerminKalenderRaster.RecordCount > 0 Then
                        rstTerminKalenderRaster.MoveLast    'auffllen
                        rstTerminKalenderRaster.MoveFirst
                        Do While Not rstTerminKalenderRaster.EOF
                            rstTerminKalenderRaster.Edit
                            rstTerminKalenderRaster!lfd_Nr_Kalender = Me.Zu_Kalender.Value
                            rstTerminKalenderRaster.Update
                            rstTerminKalenderRaster.MoveNext
                        Loop
                    End If
                    rstTerminKalenderRaster.Close

                    'Neue Kalender-Nummer eintragen
                    rstTermine.Edit
                    rstTermine!lfd_Nr_Kalender = Me.Zu_Kalender.Value
                    rstTermine.Update

                    TermineExport = TermineExport + 1

                End If
            Else
                'Termin wurde im Ziel-Kalender NICHT gefunden

                'Termindaten nach ICS exportieren
                tf.WriteLine ("BEGIN:VEVENT")
                TerminICS = "CREATED:" & Format(Now(), "yyyymmdd") & "T000000"
                tf.WriteLine (TerminICS)
                TerminICS = "LAST-MODIFIED:" & Format(Now(), "yyyymmdd") & "T000000"
                tf.WriteLine (TerminICS)
                TerminICS = "DTSTAMP:" & Format(Now(), "yyyymmdd") & "T000000"
                tf.WriteLine (TerminICS)
                'Kategorie ermitteln
                strFilter = "[lfd_Nr]=" & rstTermine!lfd_Nr_Kategorie
                rstKategorie.FindFirst (strFilter)
                If rstKategorie.NoMatch = False Then
                    If rstKategorie!Kategorie_ID <> "0123456789DUMMY9876543210" Then
                        TerminICS = "CATEGORIES:" & rstKategorie!Name1
                        tf.WriteLine (ANSIzuUTF8String(TerminICS, True))
                    End If
                End If
                TerminICS = "SUMMARY:" & rstTermine!Betreff
                tf.WriteLine (ANSIzuUTF8String(TerminICS, True))
                'Termin Privat?
                If rstTermine!Privat = True Then
                    tf.WriteLine ("CLASS:PRIVATE")
                End If
                TerminICS = "UID:" & rstTermine!Termin_ID
                tf.WriteLine (TerminICS)
                TerminICS = "DTSTART:" & Format(rstTermine!Start, "yyyymmdd") & "T" & Format(rstTermine!Start, "HHMM") & "00"
                tf.WriteLine (TerminICS)
                TerminICS = "DTEND:" & Format(rstTermine!Ende, "yyyymmdd") & "T" & Format(rstTermine!Ende, "HHMM") & "00"
                tf.WriteLine (TerminICS)

                tf.WriteLine ("END:VEVENT")
                tf.WriteBlankLines (1)

                'zunchst Kalender-Raster bearbeiten
                Set rstTerminKalenderRaster = dbs.OpenRecordset("SELECT * FROM Termine_Kalender WHERE [lfd_Nr_Termin]=" & rstTermine!lfd_Nr)
                If rstTerminKalenderRaster.RecordCount > 0 Then
                    rstTerminKalenderRaster.MoveLast    'auffllen
                    rstTerminKalenderRaster.MoveFirst
                    Do While Not rstTerminKalenderRaster.EOF
                        rstTerminKalenderRaster.Edit
                        rstTerminKalenderRaster!lfd_Nr_Kalender = Me.Zu_Kalender.Value
                        rstTerminKalenderRaster.Update
                        rstTerminKalenderRaster.MoveNext
                    Loop
                End If
                rstTerminKalenderRaster.Close

                'Neue Kalender-Nummer eintragen
                rstTermine.Edit
                rstTermine!lfd_Nr_Kalender = Me.Zu_Kalender.Value
                rstTermine.Update

                TermineExport = TermineExport + 1

            End If

            rstTermine.MoveNext
        Loop        'rstTermine
    End If          'rstTermine
    'Tabellen schlieen
    rst.Close
    rstTermine.Close
    rstKategorie.Close

    'Fortschrittsanzeige lschen
    DoCmd.Close acForm, "Terminlauf", acSaveYes
    
    'ICS-Datei schlieen
    tf.WriteLine ("END:VCALENDAR")
    tf.Close                ' Textfile schlieen
    Set fs = Nothing        ' FileSystemObject schlieen
    
    
    'Erfolgsmeldung
    MsgBox "Die bertragung verlief fehlerfrei." & vbNewLine & vbNewLine & _
           "Es wurden " & TermineExport & " Termine exportiert, " & vbNewLine & TermineGeloescht & _
           " Termine waren bereits vorhanden.", vbInformation + vbOKOnly, "Fertig"
    
Exit_START_Button_Click:
    Exit Sub

Err_START_Button_Click:
    MsgBox err.Description
    Resume Exit_START_Button_Click

End Sub


Private Sub Von_Kalender_AfterUpdate()
    
    'Start-Knopf erst mal generell sperren
    Me.START_Button.Enabled = False
    
    If Me.Von_Kalender.Value = Me.Zu_Kalender.Value Then
        'beide Kalender-Auswhalen sind identisch
        Me.Text_Beide_gleich.Visible = True
        Me.START_Button.Enabled = False
    Else
        'beide Kalender-Auswahlen sind verschieden
        Me.Text_Beide_gleich.Visible = False
        If (Me.Von_Kalender.Value > 0) And (Me.Zu_Kalender.Value > 0) Then
            'nur wenn beide Kalender tatschlich eine Auswahl enthalten
            Me.START_Button.Enabled = True
        End If
    End If
    
End Sub

Private Sub Zu_Kalender_AfterUpdate()
    'Kalenderbezeichnung fr Dateinamen merken
    TextEingabe = Me.Zu_Kalender.Text
    
    Call Von_Kalender_AfterUpdate
    
End Sub
